﻿<?xml version="1.0" standalone="no"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output indent="yes"/>
    <xsl:template match="/">
        <xsl:element name="xsl:stylesheet">
            <xsl:attribute name="version">1.0</xsl:attribute>
            <xsl:element name="xsl:template">
                <xsl:attribute name="match">/</xsl:attribute>
                <xsl:variable name="sdk_platform"       select="substring(Root/Property[@NAME='ID'], 2, 36)"/>
                <xsl:variable name="sdk_ceVersion"	select="Root/Property[@NAME='CEVersion']"/>
                <xsl:variable name="sdk_osmajor"  	select="Root/Property[@NAME='OSMajor']"/>
                <xsl:variable name="sdk_osminor"  	select="Root/Property[@NAME='OSMinor']"/>
                <xsl:variable name="sdk_platformVersionPath">
                    wce<xsl:number value="floor( $sdk_ceVersion div 100 ) * 100"/>
                </xsl:variable>
                <xsl:variable name="sdk_osVersion">
                    <xsl:number value="$sdk_ceVersion * 10"/>
                </xsl:variable>
                <xsl:variable name="default_DeviceEmulator_Image" select="Root/PropertyBag[@NAME='DeviceEmulation']/Property[@NAME='Default Image']"/>
                <!-- substring( ..., 2, 36 ) is used to strip braces from a GUID -->
                <!-- !!! NOTE: This template is dependent on the sdk_dyn_InstallRootDir macro, the SDK installation root directory. -->
                <ADDONCONTAINER>
                    <!-- What to make sure we process before any Image Addon's -->
                    <ADDON Priority="200">
                        <PLATFORMCONTAINER>
                            <PLATFORM _InstallChildrenOnly="false">
                                <xsl:attribute name="Name">
                                    <xsl:value-of select="$sdk_name"/>
                                </xsl:attribute>
                                <xsl:attribute name="ID">
                                    <xsl:value-of select="$sdk_platform"/>
                                </xsl:attribute>
                                <DEVICECONTAINER>
                                    <!-- process each device emulation bag -->
                                    <xsl:for-each select="Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag">
                                        <xsl:if test="Property[@NAME='Enabled']='1'">
                                            <DEVICE Protected="true">
                                                <xsl:attribute name="Name">
                                                    <xsl:value-of select="Property[@NAME='ImageName']"/>
                                                </xsl:attribute>
                                                <xsl:attribute name="ID">
                                                    <xsl:value-of select="substring(Property[@NAME='VMID'], 2, 36)"/>
                                                </xsl:attribute>
                                                <PROPERTYCONTAINER>
                                                    <PROPERTY ID="OS_Version">
                                                        <xsl:value-of select="$sdk_osVersion"/>
                                                    </PROPERTY>
                                                    <PROPERTY ID="OS">default</PROPERTY>
                                                    <PROPERTY ID="Emulator" Protected="true">true</PROPERTY>
                                                    <PROPERTY ID="CpuName">
                                                        <xsl:value-of select="Property[@NAME='CpuName']"/>
                                                    </PROPERTY>
                                                    <PROPERTY ID="LocalClientFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\ConManClient2.exe</PROPERTY>
                                                    <PROPERTY ID="RemoteClientFile" Protected="true">\Windows\ConManClient2.exe</PROPERTY>
                                                    <PROPERTY ID="LocalShutdownFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\ClientShutdown.exe</PROPERTY>
                                                    <PROPERTY ID="RemoteShutdownFile" Protected="true">\Windows\ClientShutdown.exe</PROPERTY>

                                                    <PROPERTY ID="RemoteCcClientFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\ConManClient2.exe</PROPERTY>
                                                    <PROPERTY ID="RemoteCcShutdownFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\ClientShutdown.exe</PROPERTY>
                                                    <PROPERTY ID="RemoteCcTransportLoaderFile" Protected="true">%CSIDL_WINDOWS%\eDbgTL.dll</PROPERTY>
                                                    <PROPERTY ID="RemoteCcCMAcceptFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\CMAccept.exe</PROPERTY>
                                                    <!-- The current transport is the device emulator transport -->
                                                    <PROPERTY ID="B333580E-3924-492e-98E5-DF57E787591B" Protected="false">26753017-B5BB-4b67-BEE3-862676DE23DC</PROPERTY>
                                                    <!-- The current boostrap is the device emulator bootstrap -->
                                                    <PROPERTY ID="D7C86969-EB5F-41e2-96CC-290683622203" Protected="true">ECDA0E20-34EF-41CD-9574-A51C52B45037</PROPERTY>
                                                    <xsl:comment> Transport service property overrides </xsl:comment>
                                                    <PROPERTY ID="B333580E-3924-492e-98E5-DF57E787591B_ALL">
                                                        <PROPERTYCONTAINER>
                                                            <xsl:comment> TCP Transport </xsl:comment>
                                                            <xsl:element name="xsl:element">
                                                                <xsl:attribute name="name">PROPERTY</xsl:attribute>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_SERVICECATEGORIES_8_0/TRANSPORT_TRANSPORTNAME_TCPCONNECT</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">ID</xsl:attribute>D8E78E43-D8D6-4e57-8AD4-2164254C16D5
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Protected</xsl:attribute>false
                                                                </xsl:element>
                                                                <PROPERTYCONTAINER>
                                                                    <PROPERTY ID="default" Protected="false">no</PROPERTY>
                                                                    <PROPERTY ID="type" Protected="false">emulator</PROPERTY>
                                                                    <PROPERTY ID="LocalTransportFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\tcpconnectiona.dll</PROPERTY>
                                                                    <PROPERTY ID="RemoteTransportFile" Protected="true">%CSIDL_WINDOWS%\tcpconnectiona.dll</PROPERTY>
                                                                    <PROPERTY ID="ip" Protected="false">127.0.0.1</PROPERTY>
                                                                    <PROPERTY ID="port" Protected="false">5654</PROPERTY>
                                                                    <PROPERTY ID="useCustomPort" Protected="false">no</PROPERTY>
                                                                    <PROPERTY ID="authenticate" Protected="false">false</PROPERTY>
                                                                    <PROPERTY ID="disableauthentication" Protected="false">yes</PROPERTY>
                                                                </PROPERTYCONTAINER>
                                                            </xsl:element>
                                                            <xsl:comment> DMA Transport </xsl:comment>
                                                            <xsl:element name="xsl:element">
                                                                <xsl:attribute name="name">PROPERTY</xsl:attribute>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_SERVICECATEGORIES_8_0/TRANSPORT_TRANSPORTNAME_DMA</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">ID</xsl:attribute>26753017-B5BB-4b67-BEE3-862676DE23DC
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Protected</xsl:attribute>false
                                                                </xsl:element>
                                                                <PROPERTYCONTAINER>
                                                                    <PROPERTY ID="default" Protected="false">no</PROPERTY>
                                                                    <PROPERTY ID="type" Protected="false">emulator</PROPERTY>
                                                                    <PROPERTY ID="LocalTransportFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\devicedma.dll</PROPERTY>
                                                                    <PROPERTY ID="RemoteTransportFile" Protected="true">%CSIDL_WINDOWS%\devicedma.dll</PROPERTY>
                                                                    <PROPERTY ID="ip" Protected="false">127.0.0.1</PROPERTY>
                                                                    <PROPERTY ID="port" Protected="false">5654</PROPERTY>
                                                                    <PROPERTY ID="authenticate" Protected="false">false</PROPERTY>
                                                                    <PROPERTY ID="disableauthentication" Protected="false">yes</PROPERTY>
                                                                </PROPERTYCONTAINER>
                                                            </xsl:element>
                                                        </PROPERTYCONTAINER>
                                                    </PROPERTY>
                                                    <xsl:comment> Bootstrap service property overrides </xsl:comment>
                                                    <PROPERTY ID="D7C86969-EB5F-41e2-96CC-290683622203_ALL">
                                                        <PROPERTYCONTAINER>
                                                            <xsl:comment> Device Emulation Bootstrap </xsl:comment>
                                                            <xsl:element name="xsl:element">
                                                                <xsl:attribute name="name">PROPERTY</xsl:attribute>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_VISUALSTUDIO_SERVICECATEGORIES_8_0/STARTUP_STARTUPNAME_DEVICEEMULATION</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">ID</xsl:attribute>ECDA0E20-34EF-41CD-9574-A51C52B45037
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Protected</xsl:attribute>false
                                                                </xsl:element>
                                                                <PROPERTYCONTAINER>
                                                                    <PROPERTY ID="default" Protected="false">no</PROPERTY>
                                                                    <PROPERTY ID="type" Protected="false">emulator</PROPERTY>
                                                                    <PROPERTY ID="VMID" Protected="false">
                                                                        {<xsl:value-of select="substring(Property[@NAME='VMID'], 2, 36)"/>}
                                                                    </PROPERTY>
                                                                    <PROPERTY ID="AdditionalParameters" Protected="false">
                                                                        <xsl:choose>
                                                                            <xsl:when test="Property[@NAME='AdditionalParameters']!=''">
                                                                                <xsl:value-of select="Property[@NAME='AdditionalParameters']"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                /funckey 193
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </PROPERTY>
                                                                    <xsl:if test="Property[@NAME='VMM_CLSID']!=''">
                                                                        <PROPERTY ID="VMM_CLSID">
                                                                            <xsl:value-of select="Property[@NAME='VMM_CLSID']"/>
                                                                        </PROPERTY>
                                                                    </xsl:if>
                                                                    <xsl:if test="Property[@NAME='VMM_IID']!=''">
                                                                        <PROPERTY ID="VMM_IID">
                                                                            <xsl:value-of select="Property[@NAME='VMM_IID']"/>
                                                                        </PROPERTY>
                                                                    </xsl:if>
                                                                    <xsl:if test="Property[@NAME='DEVT_CLSID']!=''">
                                                                        <PROPERTY ID="DEVT_CLSID">
                                                                            <xsl:value-of select="Property[@NAME='DEVT_CLSID']"/>
                                                                        </PROPERTY>
                                                                    </xsl:if>
                                                                    <xsl:if test="Property[@NAME='DEVT_IID']!=''">
                                                                        <PROPERTY ID="DEVT_IID">
                                                                            <xsl:value-of select="Property[@NAME='DEVT_IID']"/>
                                                                        </PROPERTY>
                                                                    </xsl:if>
                                                                    <PROPERTY ID="OSBinImage" Protected="false">
                                                                        <xsl:value-of select="$sdk_dyn_InstallRootDir"/>
                                                                        <xsl:value-of select="Property[@NAME='Bin Dest']"/>
                                                                    </PROPERTY>
                                                                    <PROPERTY ID="ScreenWidth" Protected="false">
                                                                        <xsl:choose>
                                                                            <xsl:when test="Property[@NAME='Default Skin']!=''">
                                                                                <xsl:variable name="DefaultSkin"        select="Property[@NAME='Default Skin']"/>
                                                                                <xsl:value-of select="PropertyBag[@NAME='Skins']/PropertyBag[@NAME=$DefaultSkin]/Property[@NAME='DisplayWidth']"/>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </PROPERTY>
                                                                    <PROPERTY ID="ScreenHeight" Protected="false">
                                                                        <xsl:choose>
                                                                            <xsl:when test="Property[@NAME='Default Skin']!=''">
                                                                                <xsl:variable name="DefaultSkin"        select="Property[@NAME='Default Skin']"/>
                                                                                <xsl:value-of select="PropertyBag[@NAME='Skins']/PropertyBag[@NAME=$DefaultSkin]/Property[@NAME='DisplayHeight']"/>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </PROPERTY>
                                                                    <PROPERTY ID="ColorDepth" Protected="false">
                                                                        <xsl:value-of select="Property[@NAME='BitDepth']"/>
                                                                    </PROPERTY>
                                                                    <PROPERTY ID="EthernetEnabled" Protected="false">no</PROPERTY>
                                                                    <PROPERTY ID="RAMSize" Protected="false">
                                                                        <xsl:value-of select="Property[@NAME='Memory']"/>
                                                                    </PROPERTY>
                                                                    <PROPERTY ID="HostKey" Protected="false">165</PROPERTY>
                                                                    <PROPERTY ID="UseDefaultSaveState" Protected="false">true</PROPERTY>
                                                                    <PROPERTY ID="SerialPort0" Name="SerialPort0"></PROPERTY>
                                                                    <PROPERTY ID="SerialPort1" Protected="false"></PROPERTY>
                                                                    <PROPERTY ID="SerialPort2" Protected="false"></PROPERTY>
                                                                    <PROPERTY ID="ParallelPort" Protected="false"></PROPERTY>
                                                                    <PROPERTY ID="AlwaysOnTop" Name="AlwaysOnTop">no</PROPERTY>
                                                                    <PROPERTY ID="CreateConsole" Name="CreateConsole">no</PROPERTY>
                                                                    <PROPERTY ID="CS8900Adapter" Name="CS8900Adapter">000000000000</PROPERTY>
                                                                    <PROPERTY ID="CS8900EthernetEnabled" Name="CS8900EthernetEnabled">no</PROPERTY>
                                                                    <PROPERTY ID="EnableToolTips" Name="EnableToolTips">no</PROPERTY>
                                                                    <PROPERTY ID="FlashFile" Name="FlashFile"></PROPERTY>
                                                                    <PROPERTY ID="HostOnlyEthernetEnabled" Name="HostOnlyEthernetEnabled">no</PROPERTY>
                                                                    <PROPERTY ID="ImageAddress" Name="ImageAddress"></PROPERTY>
                                                                    <PROPERTY ID="NE2000Adapter" Name="NE2000Adapter">000000000000</PROPERTY>
                                                                    <PROPERTY ID="Orientation" Name="Orientation">0</PROPERTY>
                                                                    <PROPERTY ID="ShowSkin" Name="ShowSkin">yes</PROPERTY>
                                                                    <PROPERTY ID="SpecifyAddress" Name="SpecifyAddress">no</PROPERTY>
                                                                    <PROPERTY ID="Zoom2x" Name="Zoom2x">no</PROPERTY>
                                                                    <PROPERTY ID="Skin" Protected="false">
                                                                        <xsl:choose>
                                                                            <xsl:when test="Property[@NAME='Default Skin']!=''">
                                                                                <xsl:variable name="DefaultSkin"        select="Property[@NAME='Default Skin']"/>
                                                                                <xsl:value-of select="$sdk_dyn_InstallRootDir"/>
                                                                                <xsl:value-of select="PropertyBag[@NAME='Skins']/PropertyBag[@NAME=$DefaultSkin]/Property[@NAME='Destination']"/>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </PROPERTY>
                                                                    <PROPERTY ID="SkinEngine" Protected="false" _UseVSRelativePath="true">smartdevices\emulators\skin.dll</PROPERTY>
                                                                </PROPERTYCONTAINER>
                                                            </xsl:element>
                                                        </PROPERTYCONTAINER>
                                                    </PROPERTY>
                                                    <PROPERTY ID="OutputLocation">%CSIDL_PROGRAM_FILES%</PROPERTY>
                                                    <PROPERTY ID="OutputLocation_ALL">
                                                        <PROPERTYCONTAINER>
                                                            <PROPERTY ID="\">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_ROOT</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_PERSONAL%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PERSONAL</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_PROGRAMS%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PROGRAMS</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_PROGRAM_FILES%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PROGRAM_FILES</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_APPDATA%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_APPDATA</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_COMMON_APPDATA%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_COMMON_APPDATA</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_WINDOWS%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_WINDOWS</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_FONTS%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_FONTS</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_STARTMENU%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_STARTMENU</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_STARTUP%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_STARTUP</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                        </PROPERTYCONTAINER>
                                                    </PROPERTY>
                                                </PROPERTYCONTAINER>
                                            </DEVICE>
                                        </xsl:if>
                                    </xsl:for-each>
                                    <!-- process each physical device bag -->
                                    <xsl:for-each select="Root/PropertyBag[@NAME='CPU info']/PropertyBag">
                                        <xsl:if test="Property[@NAME='IsEmulation']='0'">
                                            <DEVICE Protected="true">
                                                <xsl:attribute name="Name">
                                                    <xsl:value-of select="Property[@NAME='PbCfgName']"/>
                                                </xsl:attribute>
                                                <xsl:attribute name="ID">
                                                    <xsl:value-of select="$sdk_platform"/>
                                                    <xsl:value-of select="substring(Property[@NAME='CpuGuid'], 2, 36)"/>
                                                </xsl:attribute>
                                                <PROPERTYCONTAINER>
                                                    <PROPERTY ID="OS_Version" Protected="false">
                                                        <xsl:value-of select="$sdk_osVersion"/>
                                                    </PROPERTY>
                                                    <PROPERTY ID="OS" Protected="false">default</PROPERTY>
                                                    <PROPERTY ID="CpuName">
                                                        <xsl:value-of select="Property[@NAME='CpuName']"/>
                                                    </PROPERTY>
                                                    <PROPERTY ID="LocalClientFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\ConManClient2.exe</PROPERTY>
                                                    <PROPERTY ID="RemoteClientFile" Protected="true">\Windows\CoreCon%CcVersion%\ConManClient2.exe</PROPERTY>
                                                    <PROPERTY ID="LocalShutdownFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\ClientShutdown.exe</PROPERTY>
                                                    <PROPERTY ID="RemoteShutdownFile" Protected="true">\Windows\CoreCon%CcVersion%\ClientShutdown.exe</PROPERTY>

                                                    <PROPERTY ID="RemoteCcClientFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\ConManClient2.exe</PROPERTY>
                                                    <PROPERTY ID="RemoteCcShutdownFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\ClientShutdown.exe</PROPERTY>
                                                    <PROPERTY ID="RemoteCcTransportLoaderFile" Protected="true">%CSIDL_WINDOWS%\eDbgTL.dll</PROPERTY>
                                                    <PROPERTY ID="RemoteCcCMAcceptFile" Protected="true">%CSIDL_WINDOWS%\CoreCon%CcVersion%\CMAccept.exe</PROPERTY>
                                                    <!-- The current transport is the TCP connect transport -->
                                                    <PROPERTY ID="B333580E-3924-492e-98E5-DF57E787591B" Protected="false">D8E78E43-D8D6-4e57-8AD4-2164254C16D5</PROPERTY>
                                                    <!-- The current boostrap is the ActiveSync bootstrap -->
                                                    <PROPERTY ID="D7C86969-EB5F-41e2-96CC-290683622203" Protected="false">6CFC41FD-50BA-43d2-9ACD-6A2A874D2853</PROPERTY>
                                                    <xsl:comment> Transport Service property overrides </xsl:comment>
                                                    <PROPERTY ID="B333580E-3924-492e-98E5-DF57E787591B_ALL">
                                                        <PROPERTYCONTAINER>
                                                            <xsl:comment> TCP Connect Transport </xsl:comment>
                                                            <xsl:element name="xsl:element">
                                                                <xsl:attribute name="name">PROPERTY</xsl:attribute>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_SERVICECATEGORIES_8_0/TRANSPORT_TRANSPORTNAME_TCPCONNECT</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">ID</xsl:attribute>D8E78E43-D8D6-4e57-8AD4-2164254C16D5
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Protected</xsl:attribute>true
                                                                </xsl:element>
                                                                <PROPERTYCONTAINER>
                                                                    <PROPERTY ID="default" Protected="false">no</PROPERTY>
                                                                    <PROPERTY ID="type" Protected="false">tcp_connect</PROPERTY>
                                                                    <PROPERTY ID="ip" Protected="false">127.0.0.1</PROPERTY>
                                                                    <PROPERTY ID="port" Protected="false">6791</PROPERTY>
                                                                    <PROPERTY ID="authenticate" Protected="false">false</PROPERTY>
                                                                    <PROPERTY ID="useAutoAddress" Protected="false">yes</PROPERTY>
                                                                    <PROPERTY ID="useCustomPort" Protected="false">no</PROPERTY>
                                                                    <PROPERTY ID="LocalTransportFile" Protected="true" _UseCcRelativePath="true">target\wce400\%cpu%\TcpConnectionA.dll</PROPERTY>
                                                                    <PROPERTY ID="RemoteTransportFile" Protected="true">%CSIDL_WINDOWS%\TcpConnectionA.dll</PROPERTY>
                                                                </PROPERTYCONTAINER>
                                                            </xsl:element>
                                                        </PROPERTYCONTAINER>
                                                    </PROPERTY>

                                                    <xsl:comment> Bootstrap service property overrides </xsl:comment>
                                                    <PROPERTY ID="D7C86969-EB5F-41e2-96CC-290683622203_ALL">
                                                        <PROPERTYCONTAINER>
                                                            <xsl:comment> ActiveSync Bootstrap </xsl:comment>
                                                            <xsl:element name="xsl:element">
                                                                <xsl:attribute name="name">PROPERTY</xsl:attribute>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_SERVICECATEGORIES_8_0/STARTUP_STARTUPNAME_ACTIVESYNC</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">ID</xsl:attribute>6CFC41FD-50BA-43d2-9ACD-6A2A874D2853
                                                                </xsl:element>
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Protected</xsl:attribute>false
                                                                </xsl:element>
                                                                <PROPERTYCONTAINER>
                                                                    <PROPERTY ID="default" Protected="false">no</PROPERTY>
                                                                    <PROPERTY ID="type" Protected="false">activesync</PROPERTY>
                                                                </PROPERTYCONTAINER>
                                                            </xsl:element>
                                                        </PROPERTYCONTAINER>
                                                    </PROPERTY>
                                                    <PROPERTY ID="OutputLocation">%CSIDL_PROGRAM_FILES%</PROPERTY>
                                                    <PROPERTY ID="OutputLocation_ALL">
                                                        <PROPERTYCONTAINER>
                                                            <PROPERTY ID="\">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_ROOT</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_PERSONAL%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PERSONAL</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_PROGRAMS%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PROGRAMS</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_PROGRAM_FILES%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_PROGRAM_FILES</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_APPDATA%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_APPDATA</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_COMMON_APPDATA%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_COMMON_APPDATA</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_WINDOWS%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_WINDOWS</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_FONTS%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_FONTS</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_STARTMENU%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_STARTMENU</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                            <PROPERTY ID="%CSIDL_STARTUP%">
                                                                <xsl:element name="xsl:attribute">
                                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                                    <xsl:element name="xsl:value-of">
                                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/CSIDL_STARTUP</xsl:attribute>
                                                                    </xsl:element>
                                                                </xsl:element>
                                                            </PROPERTY>
                                                        </PROPERTYCONTAINER>
                                                    </PROPERTY>
                                                </PROPERTYCONTAINER>
                                            </DEVICE>
                                        </xsl:if>
                                    </xsl:for-each>
                                </DEVICECONTAINER>
                                <PROJECTCONTAINER>
                                    <xsl:choose>
                                        <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedProjectTypes']">
                                            <xsl:choose>
                                                <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedProjectTypes']/Property[@NAME='WindowsApp']">
                                                    <PROJECT ID="Windows Application">
                                                        <xsl:element name="xsl:attribute">
                                                            <xsl:attribute name="name">Name</xsl:attribute>
                                                            <xsl:element name="xsl:value-of">
                                                                <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_WINDOWSAPP</xsl:attribute>
                                                            </xsl:element>
                                                        </xsl:element>
                                                        <PROPERTYCONTAINER>
                                                            <PROPERTY ID="Directory">Windows Application</PROPERTY>
                                                            <PROPERTY ID="SortIndex">10</PROPERTY>
                                                        </PROPERTYCONTAINER>
                                                    </PROJECT>
                                                </xsl:when>
                                            </xsl:choose>
                                            <xsl:choose>
                                                <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedProjectTypes']/Property[@NAME='ClassLib']">
                                                    <PROJECT ID="Class Library">
                                                        <xsl:element name="xsl:attribute">
                                                            <xsl:attribute name="name">Name</xsl:attribute>
                                                            <xsl:element name="xsl:value-of">
                                                                <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_CLASSLIBRARY</xsl:attribute>
                                                            </xsl:element>
                                                        </xsl:element>
                                                        <PROPERTYCONTAINER>
                                                            <PROPERTY ID="Directory">Class Library</PROPERTY>
                                                            <PROPERTY ID="SortIndex">20</PROPERTY>
                                                        </PROPERTYCONTAINER>
                                                    </PROJECT>
                                                </xsl:when>
                                            </xsl:choose>
                                            <xsl:choose>
                                                <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedProjectTypes']/Property[@NAME='ControlLib']">
                                                    <PROJECT ID="Windows Control Library">
                                                        <xsl:element name="xsl:attribute">
                                                            <xsl:attribute name="name">Name</xsl:attribute>
                                                            <xsl:element name="xsl:value-of">
                                                                <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_WINDOWSCTRLLIB</xsl:attribute>
                                                            </xsl:element>
                                                        </xsl:element>
                                                        <PROPERTYCONTAINER>
                                                            <PROPERTY ID="Directory">Windows Control Library</PROPERTY>
                                                            <PROPERTY ID="SortIndex">25</PROPERTY>
                                                        </PROPERTYCONTAINER>
                                                    </PROJECT>
                                                </xsl:when>
                                            </xsl:choose>
                                            <xsl:choose>
                                                <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedProjectTypes']/Property[@NAME='ConsoleApp']">
                                                    <PROJECT ID="Console Application">
                                                        <xsl:element name="xsl:attribute">
                                                            <xsl:attribute name="name">Name</xsl:attribute>
                                                            <xsl:element name="xsl:value-of">
                                                                <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_CONSOLEAPP</xsl:attribute>
                                                            </xsl:element>
                                                        </xsl:element>
                                                        <PROPERTYCONTAINER>
                                                            <PROPERTY ID="Directory">Console Application</PROPERTY>
                                                            <PROPERTY ID="SortIndex">40</PROPERTY>
                                                        </PROPERTYCONTAINER>
                                                    </PROJECT>
                                                </xsl:when>
                                            </xsl:choose>
                                            <xsl:choose>
                                                <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedProjectTypes']/Property[@NAME='EmptyProject']">
                                                    <PROJECT ID="Empty Project">
                                                        <xsl:element name="xsl:attribute">
                                                            <xsl:attribute name="name">Name</xsl:attribute>
                                                            <xsl:element name="xsl:value-of">
                                                                <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_EMPTY</xsl:attribute>
                                                            </xsl:element>
                                                        </xsl:element>
                                                        <PROPERTYCONTAINER>
                                                            <PROPERTY ID="Directory">Empty Project</PROPERTY>
                                                            <PROPERTY ID="SortIndex">50</PROPERTY>
                                                        </PROPERTYCONTAINER>
                                                    </PROJECT>
                                                </xsl:when>
                                            </xsl:choose>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <PROJECT ID="Windows Application">
                                                <xsl:element name="xsl:attribute">
                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                    <xsl:element name="xsl:value-of">
                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_WINDOWSAPP</xsl:attribute>
                                                    </xsl:element>
                                                </xsl:element>
                                                <PROPERTYCONTAINER>
                                                    <PROPERTY ID="Directory">Windows Application</PROPERTY>
                                                    <PROPERTY ID="SortIndex">10</PROPERTY>
                                                </PROPERTYCONTAINER>
                                            </PROJECT>
                                            <PROJECT ID="Class Library">
                                                <xsl:element name="xsl:attribute">
                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                    <xsl:element name="xsl:value-of">
                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_CLASSLIBRARY</xsl:attribute>
                                                    </xsl:element>
                                                </xsl:element>
                                                <PROPERTYCONTAINER>
                                                    <PROPERTY ID="Directory">Class Library</PROPERTY>
                                                    <PROPERTY ID="SortIndex">20</PROPERTY>
                                                </PROPERTYCONTAINER>
                                            </PROJECT>
                                            <PROJECT ID="Windows Control Library">
                                                <xsl:element name="xsl:attribute">
                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                    <xsl:element name="xsl:value-of">
                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_WINDOWSCTRLLIB</xsl:attribute>
                                                    </xsl:element>
                                                </xsl:element>
                                                <PROPERTYCONTAINER>
                                                    <PROPERTY ID="Directory">Windows Control Library</PROPERTY>
                                                    <PROPERTY ID="SortIndex">25</PROPERTY>
                                                </PROPERTYCONTAINER>
                                            </PROJECT>
                                            <PROJECT ID="Console Application">
                                                <xsl:element name="xsl:attribute">
                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                    <xsl:element name="xsl:value-of">
                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_CONSOLEAPP</xsl:attribute>
                                                    </xsl:element>
                                                </xsl:element>
                                                <PROPERTYCONTAINER>
                                                    <PROPERTY ID="Directory">Console Application</PROPERTY>
                                                    <PROPERTY ID="SortIndex">40</PROPERTY>
                                                </PROPERTYCONTAINER>
                                            </PROJECT>
                                            <PROJECT ID="Empty Project">
                                                <xsl:element name="xsl:attribute">
                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                    <xsl:element name="xsl:value-of">
                                                        <xsl:attribute name="select">LANGUAGE/MICROSOFT_WINDOWSCE_2_0/PLATFORM_PROJECTNAME_EMPTY</xsl:attribute>
                                                    </xsl:element>
                                                </xsl:element>
                                                <PROPERTYCONTAINER>
                                                    <PROPERTY ID="Directory">Empty Project</PROPERTY>
                                                    <PROPERTY ID="SortIndex">50</PROPERTY>
                                                </PROPERTYCONTAINER>
                                            </PROJECT>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </PROJECTCONTAINER>
                                <FORMFACTORCONTAINER>
                                    <xsl:choose>
                                        <xsl:when test="Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag/PropertyBag[@NAME='Skins']/PropertyBag/* !=''">
                                            <!-- process each device emulation bag -->
                                            <xsl:for-each select="Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag">
                                                <xsl:if test="Property[@NAME='Enabled']='1'">
                                                    <xsl:for-each select="PropertyBag[@NAME='Skins']/PropertyBag">
                                                        <xsl:element name="FORMFACTOR">
                                                            <xsl:attribute name="ID">
                                                                <xsl:value-of select="@NAME"/>
                                                            </xsl:attribute>
                                                            <xsl:attribute name="Name">
                                                                <xsl:value-of select="Property[@NAME='Display_Name']"/>
                                                            </xsl:attribute>
                                                            <xsl:attribute name="Protected">true</xsl:attribute>
                                                            <PROPERTYCONTAINER>
                                                                <xsl:choose>
                                                                    <xsl:when test="../../Property[@NAME='DPIX']!=''">
                                                                        <PROPERTY ID="DPIX">
                                                                            <xsl:value-of select="../../Property[@NAME='DPIX']"/>
                                                                        </PROPERTY>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <PROPERTY ID="DPIX">96</PROPERTY>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                                <xsl:choose>
                                                                    <xsl:when test="../../Property[@NAME='DPIY']!=''">
                                                                        <PROPERTY ID="DPIY">
                                                                            <xsl:value-of select="../../Property[@NAME='DPIY']"/>
                                                                        </PROPERTY>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <PROPERTY ID="DPIY">96</PROPERTY>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                                <PROPERTY ID="SHOWSKIN">true</PROPERTY>
                                                                <xsl:choose>
                                                                    <xsl:when test="../../Property[@NAME='SupportRotation']!=''">
                                                                        <PROPERTY ID="SupportRotation">true</PROPERTY>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <PROPERTY ID="SupportRotation">false</PROPERTY>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                                <PROPERTY ID="DisplayWidth">
                                                                    <xsl:value-of select="Property[@NAME='DisplayWidth']"/>
                                                                </PROPERTY>
                                                                <PROPERTY ID="DisplayHeight">
                                                                    <xsl:value-of select="Property[@NAME='DisplayHeight']"/>
                                                                </PROPERTY>
                                                                <PROPERTY ID="ColorDepth">
                                                                    <xsl:value-of select="../../Property[@NAME='BitDepth']"/>
                                                                </PROPERTY>
                                                                <PROPERTY ID="Skin" Protected="false">
                                                                    <xsl:value-of select="$sdk_dyn_InstallRootDir"/>
                                                                    <xsl:value-of select="Property[@NAME='Destination']"/>
                                                                </PROPERTY>
                                                                <xsl:choose>
                                                                    <xsl:when test="Property[@NAME='KeyMapping']!=''">
                                                                        <PROPERTY ID="KeyMapping">
                                                                            <xsl:value-of select="$sdk_dyn_InstallRootDir"/>
                                                                            <xsl:value-of select="Property[@NAME='KeyMapping']"/>
                                                                        </PROPERTY>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <PROPERTY ID="KeyMapping"></PROPERTY>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </PROPERTYCONTAINER>
                                                        </xsl:element>
                                                    </xsl:for-each>
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:element name="FORMFACTOR">
                                                <xsl:element name="xsl:attribute">
                                                    <xsl:attribute name="name">Name</xsl:attribute>
                                                    <xsl:value-of select="$sdk_name"/>
                                                </xsl:element>
                                                <xsl:element name="xsl:attribute">
                                                    <xsl:attribute name="name">ID</xsl:attribute>
                                                    <xsl:value-of select="$sdk_name"/>
                                                </xsl:element>
                                                <PROPERTYCONTAINER>
                                                    <PROPERTY ID="DPIX">96</PROPERTY>
                                                    <PROPERTY ID="DPIY">96</PROPERTY>
                                                    <PROPERTY ID="SHOWSKIN">false</PROPERTY>
                                                    <PROPERTY ID="SupportRotation">false</PROPERTY>
                                                    <PROPERTY ID="DisplayWidth">640</PROPERTY>
                                                    <PROPERTY ID="DisplayHeight">480</PROPERTY>
                                                    <PROPERTY ID="ColorDepth">16</PROPERTY>
                                                    <PROPERTY ID="Skin"></PROPERTY>
                                                    <PROPERTY ID="KeyMapping"></PROPERTY>
                                                </PROPERTYCONTAINER>
                                            </xsl:element>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </FORMFACTORCONTAINER>
                                <PROPERTYCONTAINER>
                                    <!-- This makes this platform show in the WinCe Profile -->
                                    <PROPERTY ID="OSVersion">
                                        <xsl:value-of select="$sdk_osmajor"/>.<xsl:value-of select="$sdk_osminor"/>
                                    </PROPERTY>
                                    <xsl:choose>
                                        <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/Property[@NAME='SupportedProfile']!=''">
                                            <PROPERTY ID="SupportedProfile" Protected="false">
                                                <xsl:value-of select="Root/PropertyBag[@NAME='DeveloperTools']/Property[@NAME='SupportedProfile']"/>
                                            </PROPERTY>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <PROPERTY ID="SupportedProfile" Protected="false">E2BECB1F-8C8C-41ba-B736-9BE7D946A398</PROPERTY>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <PROPERTY ID="Profile" Protected="false">yes</PROPERTY>
                                    <PROPERTY ID="SupportedProfile" Protected="false">Generic Compact Profile</PROPERTY>
                                    <PROPERTY ID="COM+ReferenceDir" Protected="false" _UseCcRelativePath="true">v1.0.5000\Windows CE</PROPERTY>
                                    <PROPERTY ID="NDPVersion" Protected="false">v2.0.3600</PROPERTY>
                                    <PROPERTY ID="DefaultPlatform" Protected="false">
                                        <xsl:value-of select="$sdk_platform"/>
                                    </PROPERTY>

                                    <xsl:choose>
                                        <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/Property[@NAME='MinVSVersion']!=''">
                                            <PROPERTY ID="MinVSVersion" Protected="false">
                                                <xsl:value-of select="Root/PropertyBag[@NAME='DeveloperTools']/Property[@NAME='MinVSVersion']"/>
                                            </PROPERTY>
                                        </xsl:when>
                                    </xsl:choose>
                                    <xsl:choose>
                                        <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/Property[@NAME='ShowInNewProjectDialog']!=''">
                                            <PROPERTY ID="ShowInNewProjectDialog" Protected="false">
                                                <xsl:value-of select="Root/PropertyBag[@NAME='DeveloperTools']/Property[@NAME='ShowInNewProjectDialog']"/>
                                            </PROPERTY>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <PROPERTY ID="ShowInNewProjectDialog" Protected="false">false</PROPERTY>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <PROPERTY ID="SupportedLanguages">
                                        <PROPERTYCONTAINER>
                                            <xsl:choose>
                                                <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedLanguages']">
                                                    <xsl:if test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedLanguages'][Property='CSharp']">
                                                        <PROPERTY ID="CSharp" Protected="false">CSharp</PROPERTY>
                                                    </xsl:if>
                                                    <xsl:if test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedLanguages'][Property='VB']">
                                                        <PROPERTY ID="VisualBasic" Protected="false">VisualBasic</PROPERTY>
                                                    </xsl:if>
                                                    <xsl:if test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedLanguages'][Property='C++']">
                                                        <PROPERTY ID="C++" Protected="false">C++</PROPERTY>
                                                    </xsl:if>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:if test="Root/Property[@NAME='{E75B8574-8822-409C-9CDC-7B780BCC4BF6}']">
                                                        <PROPERTY ID="CSharp" Protected="false">CSharp</PROPERTY>
                                                        <PROPERTY ID="VisualBasic" Protected="false">VisualBasic</PROPERTY>
                                                    </xsl:if>
                                                    <xsl:if test="Root/Property[@NAME='{9D52DB36-F238-412D-A3B2-A651FD4489AC}']">
                                                        <PROPERTY ID="C++" Protected="false">C++</PROPERTY>
                                                    </xsl:if>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </PROPERTYCONTAINER>
                                    </PROPERTY>
                                    <xsl:choose>
                                        <xsl:when test="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedNETCFVersions']">
                                            <PROPERTY ID="SupportedNETCFVersions">
                                                <PROPERTYCONTAINER>
                                                    <xsl:for-each select="Root/PropertyBag[@NAME='DeveloperTools']/PropertyBag[@NAME='SupportedNETCFVersions']/PropertyBag">
                                                        <xsl:element name="PROPERTY" >
                                                            <xsl:attribute name="Protected">false</xsl:attribute>
                                                            <xsl:attribute name="ID">
                                                                <xsl:value-of select="Property[@NAME='ID']"/>
                                                            </xsl:attribute>
                                                            <xsl:value-of select="Property[@NAME='ID']"/>
                                                        </xsl:element>
                                                    </xsl:for-each>
                                                </PROPERTYCONTAINER>
                                            </PROPERTY>
                                        </xsl:when>
                                    </xsl:choose>

                                    <!--Extensibility related property ends-->
                                    <!-- DefaultDevice, use default emulator if present, if not use first device -->
                                    <PROPERTY ID="DefaultDevice" Protected="false">
                                        <xsl:choose>
                                            <xsl:when test="$default_DeviceEmulator_Image!=''">
                                                <xsl:value-of select="substring(Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag[@NAME=$default_DeviceEmulator_Image]/Property[@NAME='VMID'], 2, 36)"/>
                                            </xsl:when>
                                            <xsl:when test="Root/PropertyBag[@NAME='CPU info']/PropertyBag[1]/Property[@NAME='IsEmulation']='0'">
                                                <!-- Need to select the first device -->
                                                <xsl:value-of select="$sdk_platform"/>
                                                <xsl:value-of select="substring(Root/PropertyBag[@NAME='CPU info']/PropertyBag[1]/Property[@NAME='CpuGuid'], 2, 36)"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <!-- Need to select the first device -->
                                                <xsl:value-of select="$sdk_platform"/>
                                                <xsl:value-of select="substring(Root/PropertyBag[@NAME='CPU info']/PropertyBag[2]/Property[@NAME='CpuGuid'], 2, 36)"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </PROPERTY>
                                    <PROPERTY ID="WizardSortOrder" Protected="false">30</PROPERTY>
                                    <PROPERTY ID="UserListed" Protected="false">yes</PROPERTY>
                                    <PROPERTY ID="ShortName" Protected="false">WCE4</PROPERTY>
                                    <PROPERTY ID="Directory" Protected="false">Windows CE</PROPERTY>
                                    <PROPERTY ID="DefaultFormFactor" Protected="false">
                                        <xsl:choose>
                                            <xsl:when test="$default_DeviceEmulator_Image!='' and Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag[@NAME=$default_DeviceEmulator_Image]/Property[@NAME='Default Skin']!=''">
                                                <xsl:value-of select="Root/PropertyBag[@NAME='DeviceEmulation']/PropertyBag[@NAME=$default_DeviceEmulator_Image]/Property[@NAME='Default Skin']"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="$sdk_name"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </PROPERTY>
                                    <xsl:choose>
                                        <xsl:when test="Root/Property[@NAME='PlatformFamily']!=''">
                                            <PROPERTY ID="PlatformFamily" Protected="false">
                                                <xsl:value-of select="Root/Property[@NAME='PlatformFamily']"/>
                                            </PROPERTY>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <PROPERTY ID="PlatformFamily" Protected="false">WindowsCE</PROPERTY>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <xsl:choose>
                                        <xsl:when test="Root/Property[@NAME='Self_register']='1'">
                                            <PROPERTY ID="SelfRegister" Protected="false">true</PROPERTY>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <PROPERTY ID="SelfRegister" Protected="false">false</PROPERTY>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </PROPERTYCONTAINER>
                            </PLATFORM>
                        </PLATFORMCONTAINER>
                        <FILECONTAINER>
                            <xsl:for-each select="Root/PropertyBag[@NAME='Assemblies']/Property">
                                <xsl:element name="FILE">
                                    <xsl:attribute name="ID">
                                        <xsl:value-of select="."/>
                                    </xsl:attribute>
                                    <PROPERTYCONTAINER>
                                    </PROPERTYCONTAINER>
                                </xsl:element>
                            </xsl:for-each>
                        </FILECONTAINER>
                    </ADDON>
                </ADDONCONTAINER>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>
